<?php

if (!class_exists("category_access_options")) {

class category_access_options {

function setup_category_access_options_page() {
	if (function_exists('add_options_page'))
		add_options_page('Category Access', 'Category Access', 9, __FILE__,
			array('category_access_options','manage_category_access_options'));
}

function manage_category_access_options() {
	category_access_options::handle_action();

	category_access_options::print_html();
}

function print_html() {
	print "<div class='wrap'>\n";
	print "<h2> Category Access Options </h2>\n";

	$page_uri = $_SERVER['PHP_SELF'] . "?page=" . plugin_basename(__FILE__);

  // --------------------------------------------------------------

	function sort_category_ids_by_name($category_id1,$category_id2) {
		return strcmp(strtolower(get_catname($category_id1)),
			strtolower(get_catname($category_id2)));
	}

	print '
<script language="javascript">
function check_categories(class,checked)
{
	the_form = document.category_access;

	all_check_boxes = the_form.getElementsByTagName(\'input\');

	for (var i = 0; i < all_check_boxes.length; i++)
		if (all_check_boxes[i].className == class)
			all_check_boxes[i].checked = checked;
}
</script>
';

	print "<form name='category_access' method='post' action='$page_uri'>\n";

  // --------------------------------------------------------------

	{
		print "<div style='float:left;width:49%'>\n";

		// Category table
		print "<h3>Category Access for New Users</h3>\n";

		print "<p> Set the default visibility of categories for new users ".
			"below. These values can be set on a user-by-user basis in the ".
			"management page.</p>\n";

		$category_ids = get_all_category_ids();

		usort($category_ids, 'sort_category_ids_by_name');

		print "<p>\n";

		foreach ($category_ids as $category_id) {
			print "<input  class=\"category_id_default\" type=\"checkbox\" " .
				"name=\"Category_Access_cat_${category_id}_default\"";

			if (get_option("Category_Access_cat_${category_id}_default") == true)
				print " checked";

			print "> " . get_catname($category_id) . "<br/>\n";
		}

		print "</p>\n";

		print '<p>
	<input name="check_all_categories_default" type="button" id="check_all_categories_default" value="Check all categories" 
		onClick="check_categories(\'category_id_default\',true)">

	<input name="uncheck_all_categories_default" type="button" id="uncheck_all_categories_default" value="Uncheck all categories" 
		onClick="check_categories(\'category_id_default\',false)">
</p>
';

		print "</div>\n";
	}

  // --------------------------------------------------------------

  {
		print "<div style='float:right;width:49%'>\n";

		// Category table
		print "<h3>Category Access for Anonymous Users</h3>\n";

		print "<p> Set the visibility of categories for users ".
			"that are not logged in below. Usually this is the same as or more ".
			"restrictive than the access granted to new users.</p>\n";

		$category_ids = get_all_category_ids();

		usort($category_ids, 'sort_category_ids_by_name');

		print "<p>\n";

		foreach ($category_ids as $category_id) {
			print "<input  class=\"category_id_anonymous\" type=\"checkbox\" " .
				"name=\"Category_Access_cat_${category_id}_anonymous\"";

			if (get_option("Category_Access_cat_${category_id}_anonymous") == true)
				print " checked";

			print "> " . get_catname($category_id) . "<br/>\n";
		}

		print "</p>\n";

		print '<p>
	<input name="check_all_categories_anonymous" type="button" id="check_all_categories_anonymous" value="Check all categories" 
		onClick="check_categories(\'category_id_anonymous\',true)">

	<input name="uncheck_all_categories_anonymous" type="button" id="uncheck_all_categories_anonymous" value="Uncheck all categories" 
		onClick="check_categories(\'category_id_anonymous\',false)">
</p>
		';

		print "</div>\n";
	}

	print "<br style='clear:both'>\n";

  // --------------------------------------------------------------

	print "<h3>Protected Posts</h3>\n";

	print '
<script language="javascript">
function enable_disable_form_elements()
{
	the_form = document.category_access;

    private_message_div = document.getElementById("private_message_div");
	if (the_form.Category_Access_show_private_message.checked) {
		private_message_div.style.color = "black";
		the_form.Category_Access_private_message.disabled = false;
		the_form.Category_Access_private_message.style.color = "black";
		the_form.Category_Access_show_padlock_on_private_posts.disabled = false;
	} else {
		private_message_div.style.color = "gray";
		the_form.Category_Access_private_message.disabled = true;
		the_form.Category_Access_private_message.style.color = "gray";
		the_form.Category_Access_show_padlock_on_private_posts.disabled = true;
	}

    private_categories_div = document.getElementById("private_categories_div");
	if (the_form.Category_Access_show_private_categories.checked) {
		private_categories_div.style.color = "black";
		the_form.Category_Access_show_padlock_on_private_categories.disabled = false;
	} else {
		private_categories_div.style.color = "gray";
		the_form.Category_Access_show_padlock_on_private_categories.disabled = true;
	}
}
</script>

';

	print "<p><input name=Category_Access_show_private_message type=checkbox onClick='enable_disable_form_elements()'" .
		(get_option('Category_Access_show_private_message') ? " checked" : "") .
		"> Show a private message instead of hiding posts.</p>\n";

	print "<div id=private_message_div style='padding-left:2em'>\n";

	$private_message = category_access::get_private_message();

	print "<p>The private post message:<br>" .
		"<input name=Category_Access_private_message type=text size=50" .
		" value=\"$private_message\" /></p>\n";


	print "<p><input name=Category_Access_show_padlock_on_private_posts type=checkbox" .
		 (get_option('Category_Access_show_padlock_on_private_posts') ? " checked" : "") .
		 "> Show a padlock icon on the private post message.</p>\n";

	print "</div>\n";

	print "<p><input name=Category_Access_show_if_any_category_visible type=checkbox" .
		(get_option('Category_Access_show_if_any_category_visible') ? " checked" : "") .
		"> Consider a message to be visible if the user can view <em>any</em> of its categories (rather than <em>all</em> of its categories).</p>\n";


	print "<h3>The Category List</h3>\n";

	print "<p><input name=Category_Access_show_private_categories type=checkbox onClick='enable_disable_form_elements()'" .
		(get_option('Category_Access_show_private_categories') ? " checked" : "") .
		"> Show private categories.</p>\n";

	print "<div id=private_categories_div style='padding-left:2em'>\n";

	print "<p><input name=Category_Access_show_padlock_on_private_categories type=checkbox " .
		(get_option('Category_Access_show_padlock_on_private_categories') ? " checked" : "" ) .
		"> Show a padlock icon next to private categories.</p>\n";

	print '</div>

<script language="javascript">
enable_disable_form_elements();
</script>

<p class="submit">
<input type="submit" name="submit" value="Update Options &raquo;" /> 
</p>

<p class="submit">
<input type="submit" name="submit" value="Reset All Options" />
</p>

</form>
';

}

// --------------------------------------------------------------------

function handle_action() {
	global $_POST;

	if ($_POST['submit'] == 'Reset All Options') {
		delete_option('Category_Access_private_message',false);
		delete_option('Category_Access_show_private_message',false);
		delete_option('Category_Access_show_if_any_category_visible',false);
		delete_option('Category_Access_show_padlock_on_private_posts',false);

		delete_option('Category_Access_show_private_categories',false);
		delete_option('Category_Access_show_padlock_on_private_categories', false);

		$category_ids = get_all_category_ids();
		foreach ($category_ids as $category_id)
			delete_option("Category_Access_cat_${category_id}_default");
		foreach ($category_ids as $category_id)
			delete_option("Category_Access_cat_${category_id}_anonymous");

		return;
	}

	if (strpos($_POST['submit'], 'Update Options') !== false) {
		$category_ids = get_all_category_ids();

		foreach ($category_ids as $category_id) {
			if ($_POST["Category_Access_cat_${category_id}_default"] == 'on')
				update_option("Category_Access_cat_${category_id}_default", true);
			else
				update_option("Category_Access_cat_${category_id}_default", false);

			if ($_POST["Category_Access_cat_${category_id}_anonymous"] == 'on')
				update_option("Category_Access_cat_${category_id}_anonymous", true);
			else
				update_option("Category_Access_cat_${category_id}_anonymous", false);
		}

		if ($_POST['Category_Access_show_private_message'] == 'on')
			update_option('Category_Access_show_private_message', true);
		else
			update_option('Category_Access_show_private_message', false);

		if ($_POST['Category_Access_show_if_any_category_visible'] == 'on')
			update_option('Category_Access_show_if_any_category_visible', true);
		else
			update_option('Category_Access_show_if_any_category_visible', false);

		update_option('Category_Access_private_message',
			$_POST['Category_Access_private_message']);

		if ($_POST['Category_Access_show_padlock_on_private_posts'] == 'on')
			update_option('Category_Access_show_padlock_on_private_posts', true);
		else
			update_option('Category_Access_show_padlock_on_private_posts', false);

		if ($_POST['Category_Access_show_private_categories'] == 'on')
			update_option('Category_Access_show_private_categories', true);
		else
			update_option('Category_Access_show_private_categories', false);

		if ($_POST['Category_Access_show_padlock_on_private_categories'] == 'on')
			update_option('Category_Access_show_padlock_on_private_categories', true);
		else
			update_option('Category_Access_show_padlock_on_private_categories', false);

		return;
	}
}

}

}

// --------------------------------------------------------------------

add_action('admin_menu',
  array('category_access_options','setup_category_access_options_page'));

?>
