<?php

// Management page for category order plugin

class category_order_shared {

/*
Get the user-specified category order from the database. Also update it
according to any new or deleted categories in the database.
*/
function get_category_order($ignore_prior_ordering=false) {
	$serialized_category_order = get_option('Category_Order');

	if ($serialized_category_order == false || $ignore_prior_ordering)
		$category_order = array();
	else
		eval("\$category_order = $serialized_category_order;");

	$category_ids = get_all_category_ids();

	// Remove any references to unknown categories, except for ''
	for ($i=0; $i < count($category_order); $i++) {
		// Skip spacers
		if ($category_order[$i][0] == '')
			continue;

		if ( !in_array($category_order[$i][0], $category_ids) ) {
			array_splice($category_order,$i,1);
			$i--;
		}
	}

	// Add unreferenced categories to the end of the top level
	foreach ($category_ids as $category_id) {
		$found = 0;

		for ($i=0; $i < count($category_order); $i++)
			if ($category_order[$i][0] == $category_id) {
				$found = 1;
				break;
			}

		if (!$found)
			array_push($category_order,array($category_id,0));
	}

	if ($ignore_prior_ordering)
		usort($category_order, array('category_order_shared','by_category_name'));

	return $category_order;
}

// --------------------------------------------------------------------

function by_category_name($a, $b)
{
	$cat_a = get_category($a[0]);
	$al = strtolower( $cat_a->cat_name );
	$cat_b = get_category($b[0]);
	$bl = strtolower( $cat_b->cat_name );

	if ($al == $bl)
		return 0;

	return ($al > $bl) ? +1 : -1;
}

}

?>
